import serveStatic   from 'serve-static'
import finalhandler  from 'finalhandler'
import http          from 'http'
import path          from 'path'
import { fileURLToPath } from 'url'

const __dirname = path.dirname(fileURLToPath(import.meta.url))
const serve = serveStatic(__dirname)

http
  .createServer((req, res) => {
    res.setHeader('Cross-Origin-Opener-Policy',  'same-origin')
    res.setHeader('Cross-Origin-Embedder-Policy', 'require-corp')

    serve(req, res, finalhandler(req, res))
  })
  .listen(3001, () => console.log('🌐 frontend na http://localhost:3001'))
