const API_latest = 'https://emo-api.infis-projekty.eu'

const img = document.getElementById('photo')
const qr  = document.getElementById('qr')
let lastId = null

async function refresh() {
  try {
    const r = await fetch(`${API_latest}/latest`)
    if (!r.ok) return

    const { id, viewUrl, editedUrl } = await r.json()

    if (id !== lastId) {
      lastId = id

      img.src = `${editedUrl}?t=${Date.now()}`

      qr.innerHTML = ''
      new QRCode(qr, { text: viewUrl, width: 160, height: 160 })
    }
  } catch (e) {
    console.error(e)
  }
}

refresh()
setInterval(refresh, 5000)
